﻿class EditorManager {
	var sendconn:LocalConnection;
	var rcvconn:LocalConnection;
	var gldcmd, elcmd;
	var cursoroverbl:Boolean = false;
	var paused:Boolean = false;
	static public var MAX_DATA_SIZE:Number=40000;
	
	var connectString:String="BLConnectionRcv";
	
	var broadcaster:Object = new Object();
	
	function EditorManager() {
	    connectString+=_root.blRc;
	    
		sendconn = new LocalConnection();
		rcvconn = new LocalConnection();
		
		_root._lockroot=true;
		rcvconn.editLvl=this.editLvl;
		rcvconn.getLvlData=this.getLvlData;
		rcvconn.getMgrVersion=this.getMgrVersion;
		rcvconn.setCursorOverBLGUI=this.setCursorOverBLGUI;
		rcvconn.blWelcome=this.blWelcome;
		rcvconn.blInit=this.blInit;
		rcvconn.blPause=this.blPause;
		rcvconn.blResume=this.blResume;
		rcvconn.allowDomain = function (sendingDomain) { return((sendingDomain.indexOf("bonuslevel.org")<>-1) || (sendingDomain.indexOf("localhost")<>-1)); }
		
		rcvconn.connect("BLEditorConnectionSnd"+_root.blRc);
		
		AsBroadcaster.initialize(broadcaster);
	}
	// Is called by the level manager, when your editor is loaded and the BL API is ready
	public function blInit() {
		// You may implement this function
		// ...
	}
	// Is called by the level manager, when your editor is paused (put in background)
	public function blPause() {
		// You may implement this function, if you extend it don't forget to call the super.blPause() method, for the paused=true line
		// ...
		this=_root.BLManager;
		paused=true;
	}
	// Is called by the level manager, when your editor is resumed (put in foreground)
	public function blResume() {
		// You may implement this function, if you extend it don't forget to call the super.blResume() method, for the paused=false line
		// ...
		this=_root.BLManager;
		paused=false;
	}
	// Is called by the level manager, it's a request to show the welcome screen of your editor (means the editor is not currently editing any levels)
	public function blWelcome() {
		// You may implement this function
		// ...
	}
	// This function is called by the level manager, not by you. You must implement this function and return the serialized data of the currently edited level.
	// It returns true and a String containing the data when the data of the current level were successfully serialized to a String.
	// It returns false and a String containing an error message when there has been a problem serializing the level data.
	public function blGetLvlData() {
		// You must implement this function
		// ...
		sendLvlData(false, "YOU MUST IMPLEMENT THE BLGETLVLDATA FUNCTION OF THE EDITOR MANAGER");
		//sendLevelData{true,yourByteArray};
	}
	// data is a String containing the level data to be unserialized. data is the null string "" for a new level.
	// It returns true when the data were successfully interpreted as level data and when the level edition has started.
	// It returns a String containing an error message when there has been a problem and when it's not possible to edit the level.
	public function blEditLvl(data:String) {
		// You must implement this function
		// ...
		sendEditResult(false, "YOU MUST IMPLEMENT THE BLEDITLVL FUNCTION OF THE EDITOR MANAGER");
		//sendEditResult(true,"");
	}
	// Don't modify this function
	private var dataStack:String="";
	public function editLvl(cmd, data:String,packet_id:Number,packet_nb:Number) {
		if (packet_id==undefined) packet_id=0; if (packet_nb==undefined) packet_nb=1;  //default parameter
		this=_root.BLManager;
		if (packet_id==0) dataStack="";
		dataStack+=data;
		if (packet_id==packet_nb-1) {
			elcmd = cmd;
			blEditLvl(dataStack);
			dataStack="";
		}
	}
	// Don't modify this function
	public function getLvlData(cmd) {
		this=_root.BLManager;
		gldcmd = cmd;
		blGetLvlData();
	}
	// Don't modify this function
	public function sendEditResult(res:Boolean,data:String) {
		sendconn.send(connectString, "editLvlCbk", elcmd, res, data);
	}
	// Don't modify this function
	public function sendLvlData(res:Boolean, data:String) {
		//MAX_DATA_SIZE, split in small blocks of data if necessary
		var packet_nb=Math.ceil(data.length/MAX_DATA_SIZE); if (packet_nb<=0) packet_nb=1;
		for (var i=0;i<packet_nb;i++) {
			var packet:String=data.substr(i*MAX_DATA_SIZE,MAX_DATA_SIZE);
			sendconn.send(connectString, "getLvlDataCbk", gldcmd, res, packet, i, packet_nb);
		}
	}
	// Don't modify this function. You can call it to display a trace.
	// txt contains the String you want to trace
	// lvl, 0 for important, 1 for medium, 2 for info
	public function log(txt:String,lvl:Number) {
		sendconn.send(connectString, "debug",txt,lvl);
	}
	// Don't modify this function. You can call it to display the main menu
	// cmd=-1 turn on the menu as it is. Other values for specific screens. Not yet defined.
	public function showMenu(cmd:Number) {
		sendconn.send(connectString, "cmdShowMenu",cmd);
	}
	// Don't modify this function. You can call it to display the popup with an info text
	public function showInfo(txt:String) {
		sendconn.send(connectString, "cmdShowInfo",txt);
	}
	// Don't modify this function
	public function getMgrVersion() {
		this=_root.BLManager;
		sendconn.send(connectString, "setEditorManagerVersion", 2, 1);
	}
	// Don't modify this function
	// Call this method to know if the editor is paused (in background). The editor is paused when the player is playing or testing a level for example.
	public function isPaused():Boolean {
		return paused;
	}
	// Don't modify this function
	// You must call it when a mouse click is triggered in your swf, to know if you can use it or not.
	// When it returns true, the mouse cursor is over a BonusLevel menu or popup, thus you can't use the mouse click for your swf.
	public function cursorOverBLGUI() {
		return cursoroverbl;
	}
	// Don't modify this function
	public function setCursorOverBLGUI(b) {
		this=_root.BLManager;
		cursoroverbl = b;
		if (!paused) broadcaster.broadcastMessage("onBLGUIChanged",b); //dont dispatch if the app is paused
	}
	// Call this to be notified when mouse cursor state changes (BL GUI)
	public function addListener(listener:Object) {
		broadcaster.addListener(listener);
	}
	// Don't modify this function
	public var gid:Number=-1;
	public var path:String="";
	public function initialize(g:Number,p:String) {
		gid = g;
		path = p;
		blInit();
	}
	//Call this to get the path to extra resources (extra swf, images etc...)  you have uplaoded to the BL servers, you may want to load into your main swf.
	public function getExtraPath():String {
		return path;
	}
}
