﻿class GameManager {
	var sendconn:LocalConnection;
	var rcvconn:LocalConnection;
	var plcmd;
	var cursoroverbl:Boolean = false;
	var paused:Boolean = false;
	static public var MAX_DATA_SIZE:Number=40000;
	
	var connectString:String="BLConnectionRcv";
	
	var broadcaster:Object = new Object();

	
	function GameManager() {
	    connectString+=_root.blRc;
	    
		sendconn = new LocalConnection();
		rcvconn = new LocalConnection();
		
		_root._lockroot=true;
		rcvconn.playLvl=this.playLvl;
		rcvconn.getMgrVersion=this.getMgrVersion;
		rcvconn.setCursorOverBLGUI=this.setCursorOverBLGUI;
		rcvconn.newUserData=this.newUserData;
		rcvconn.userDataUpdatedCbk=this.userDataUpdatedCbk;
		rcvconn.blWelcome=this.blWelcome;
		rcvconn.blInit=this.blInit;
		rcvconn.blPause=this.blPause;
		rcvconn.blResume=this.blResume;
		rcvconn.blWin=this.blWin;
		rcvconn.blCatWin=this.blCatWin;
		rcvconn.bestPlayerData=this.bestPlayerData;
		rcvconn.blNeedBestPlayerData=this.blNeedBestPlayerData;
		rcvconn.allowDomain = function (sendingDomain) { return((sendingDomain.indexOf("bonuslevel.org")<>-1) || (sendingDomain.indexOf("localhost")<>-1)); }

		rcvconn.connect("BLPlayerConnectionSnd"+_root.blRc);
		
		AsBroadcaster.initialize(broadcaster);
	}
	// Is called by the level manager, when your game is loaded and the BL API is ready
	public function blInit() {
		// You may implement this function
		// ...
	}
	// Is called by the level manager, when your game is paused (put in background)
	public function blPause() {
		// You may implement this function, if you extend it don't forget to call the super.blPause() method, for the paused=true line
		// ...
		this=_root.BLManager;
		paused=true;
	}
	// Is called by the level manager, when your game is resumed (put in foreground)
	public function blResume() {
		// You may implement this function, if you extend it don't forget to call the super.blResume() method, for the paused=false line
		// ...
		this=_root.BLManager;
		paused=false;
	}
	// Is called by the level manager, it's a request to show the welcome screen of your game (means there is not any level currently playing)
	public function blWelcome() {
		// You may implement this function
		// ...
	}
	// Is called by the level manager when the player has just completed all levels of a category. You can implement a winning animation if you wish.
	public function blCatWin() {
		// You may implement this function
		// ...
	}
	// Is called by the level manager when the player has just completed all levels of the game. You can implement a winning animation if you wish.
	public function blWin() {
		// You may implement this function
		// ...
	}
	
	/*******************************************
	 * 
	 *  GAME BASIC API
	 * 
	 ******************************************/
			
	// This function is called by the level manager, not by you. You must implement this function. At the end of the function, if it is successful, the player is playing the corresponding level.
	// data is a String containing the level data to be unserialized.
	// official equals -1 if it's a testing of edited level, 0 if the level is not official, 1 if the level is official and has never been completed, 2 if the level is official but has already been completed
	// It returns true when the data were successfully interpreted as level data and when levels is currently playing.
	// It returns a String containing an error message when there has been a problem and when it's not possible to play the level.
	public function blPlayLvl(data:String,official:Number) {
		// You must implement this function
		// ...
		sendPlayResult(false, "YOU MUST IMPLEMENT THE blPlayLvl FUNCTION OF THE GAME MANAGER");
		//sendPlayResult(true,"");
	}
	// Don't modify this function
	// You must call it when the player has completed a level and want to go to the next one.
	// completed is true or false. If the level is not completed (false) when calling this function you switch to the next level (if you choose not to lock levels in the bonuslevel.org game parameters).
	// score is the score of the player for this level.
	// Returne true is success or a message to display if not.
	public function lvlCompleted(completed:Boolean, score:Number) {
		sendconn.send(connectString, "lvlCompleted", completed, score);
	}
	
	/*******************************************
	 * 
	 *  USER DATA API
	 * 
	 ******************************************/
	
	// This function is called by the level manager after you have requested for the user data.
	// data is a String  containing the user data. User data can be a list of items, power ups, coins etc.. the user has grabbed along the game and the levels.
	// If res is false, data is a string containing an error message.
	public function blNewUserData(res:Boolean,data:String) {

		// You may implement this function
		// ...

	}
	// Don't modify this function
	// You must call it, usually at the begining of the game, if your game implements the user data. (items, power ups that you want to keep in memory levels after levels)
	// When you call this functin, you request for the level data..
	// The BL API will reply to the request with by calling the blNewUserData function. Then the blNewUserData function will be called each time the player slot changes (player 1, player 2 etc..). If the player is a bl member, this will not happen (because the user data are save on bl servers ad not on local slot).
	public function requestUserData() {
		sendconn.send(connectString, "requestUserData");
	}

	// Don't modify this function
	// You must call it to store the user data (items, money etc...). The BL API will reply with userDataUpdatedCbk();
	public function updateUserData(data:String) {
		//MAX_DATA_SIZE, split in small blocks of data if necessary
		var packet_nb=Math.ceil(data.length/MAX_DATA_SIZE); if (packet_nb<=0) packet_nb=1;
		for (var i=0;i<packet_nb;i++) {
			var packet:String=data.substr(i*MAX_DATA_SIZE,MAX_DATA_SIZE);
			sendconn.send(connectString, "updateUserData", packet, i, packet_nb);
		}
	}
	// This function is called by the BL API after you call updateUserData.
	// If res is true, the user data has been stored successfully
	// If res is false, there has been an error. In that case, data is the the error message.
	public function userDataUpdatedCbk(res:Boolean,data:String) {
	
		// You may implement this function
		// ...
		
	}
	
	
	/*******************************************
	 * 
	 *  BEST PLAYER DATA API (since v2 only)
	 * 
	 ******************************************/
	
	// This function is called by the level manager after you have requested for the best player data.
	// data is a byteArray  containing the best player data. For example, this data can contain the description of a replay of the best player for a racing game.
	// If res is false, data is a string containing an error message.
	public function blBestPlayerData(res:Boolean, username:String, score:Number , data:String) {

		// You may implement this function
		// ...

	}
	// Don't modify this function
	// You must call it, usually at the begining of the game, if your game implements the user data. (items, power ups that you want to keep in memory levels after levels)
	// When you call this function, you request for the best player data.
	// The BL API will reply to the request with by calling the blBestPlayerData method. Unlike requestUserData, blBestPlayerData is only called once after you call the request method requestBestPlayerData.
	public function requestBestPlayerData() {
		sendconn.send(connectString, "requestBestPlayerData");
	}
	// Don't modify this function
	// You must call this method when the BL Manager call the method blNeedBestPlayerData();
	public function sendBestPlayerData(data:String) {
		//MAX_DATA_SIZE, split in small blocks of data if necessary
		var packet_nb=Math.ceil(data.length/MAX_DATA_SIZE); if (packet_nb<=0) packet_nb=1;
		for (var i=0;i<packet_nb;i++) {
			var packet:String=data.substr(i*MAX_DATA_SIZE,MAX_DATA_SIZE);
			sendconn.send(connectString, "sendBestPlayerData", packet, i, packet_nb);
		}
		
	}
	// This function is called by the level manager after you have complete a level and if you achieved the best score.
	// If your game implements the BEST PLAYER DATA API, then you have to serialize the best player data and end it to the BL Manager with the method sendBestPlayerData.
	// If your game doesn't implment the BEST PLAYER DATA API, just leave the method unchanged (the BL manager will receive a null object which means the API is not implemented).
	public function blNeedBestPlayerData() {

		// You may implement this function if you wish to use the BEST PLAYER DATA API
		// ...
		this=_root.BLManager;
		sendconn.send(connectString, "sendBestPlayerData", "", 0, 0);

	}
	
	
	
	/*******************************************
	 * 
	 *  HIDDEN API (not to be used)
	 * 
	 ******************************************/
	
	// Don't modify this function
	private var dataStack:String="";
	public function playLvl(cmd, data:String,official:Number,packet_id:Number,packet_nb:Number) {
		if (packet_id==undefined) packet_id=0; if (packet_nb==undefined) packet_nb=1;  //default parameter
		this=_root.BLManager;
		if (packet_id==0) dataStack="";
		dataStack+=data;
		if (packet_id==packet_nb-1) {
			plcmd = cmd;
			blPlayLvl(dataStack,official);
			dataStack="";
		}
	}
	// Don't modify this function
	public function sendPlayResult(res:Boolean,data:String) {
		sendconn.send(connectString, "playLvlCbk", plcmd, res, data);
	}
	// Don't modify this function
	private var userDataStack:String="";
	public function newUserData(res:Boolean,data:String,packet_id:Number,packet_nb:Number) {
		if (packet_id==undefined) packet_id=0; if (packet_nb==undefined) packet_nb=1;  //default parameter
		this=_root.BLManager;
		if (packet_id==0) userDataStack="";
		userDataStack+=data;
		if (packet_id==packet_nb-1) {
			blNewUserData(res,userDataStack);
			userDataStack="";
		}
	}
	// Don't modify this function
	private var bestPlayerDataStack:String="";
	public function bestPlayerData(res:Boolean,username:String,score:Number,data:String,packet_id:Number,packet_nb:Number) {
		if (packet_id==undefined) packet_id=0; if (packet_nb==undefined) packet_nb=1;  //default parameter
		this=_root.BLManager;
		if (packet_id==0) bestPlayerDataStack="";
		bestPlayerDataStack+=data;
		if (packet_id==packet_nb-1) {
			blBestPlayerData(res,username,score,bestPlayerDataStack);
			bestPlayerDataStack="";
		}
	}
	
	/*******************************************
	 * 
	 *  UTILS/MISC API
	 * 
	 ******************************************/
	
	// Don't modify this function. You can call it to display a trace.
	// txt contains the String you want to trace
	// lvl, 0 for important, 1 for medium, 2 for info
	public function log(txt:String,lvl:Number) {
		sendconn.send(connectString, "debug",txt,lvl);
	}
	// Don't modify this function. You can call it to display the main menu
	// cmd=-1 turn on the menu as it is. Other values for specific screens. Not yet defined.
	public function showMenu(cmd:Number) {
		sendconn.send(connectString, "cmdShowMenu",cmd);
	}
	// Don't modify this function. You can call it to display the popup with an info text
	public function showInfo(txt:String) {
		sendconn.send(connectString, "cmdShowInfo",txt);
	}
	// Don't modify this function
	// v1 (2007) : Creation
	// v2 (08/2008) : Add of Best Play Data methods
	public function getMgrVersion() {
		this=_root.BLManager;
		sendconn.send(connectString, "setPlayerManagerVersion", 2, 2);
	}
	// Don't modify this function
	// Call this method to know if the game is paused (in background). The game is paused when the player is editing a level for example.
	public function isPaused():Boolean {
		return paused;
	}
	// Don't modify this function
	// You must call it when a mouse click is triggered in your swf, to know if you can use it or not.
	// When it returns true, the mouse cursor is over a BonusLevel menu or popup, thus you can't use the mouse click for your swf.
	public function cursorOverBLGUI() {
		return cursoroverbl;
	}
	// Don't modify this function
	public function setCursorOverBLGUI(b) {
		this=_root.BLManager;
		cursoroverbl = b;
		if (!paused) broadcaster.broadcastMessage("onBLGUIChanged",b); //dont dispatch if the app is paused
	}
	// Call this to be notified when mouse cursor state changes (BL GUI)
	public function addListener(listener:Object) {
		//trace("addListener "+listener);
		broadcaster.addListener(listener);
	}
	// Don't modify this function
	public var gid:Number=-1;
	public var path:String="";
	public function initialize(g:Number,p:String) {
		gid = g;
		path = p;
		blInit();
	}
	//Call this to get the path to extra resources (extra swf, images etc...)  you have uplaoded to the BL servers, you may want to load into your main swf.
	public function getExtraPath():String {
		return path;
	}
}
