﻿class MyGameManager extends GameManager {
	static var theOne:MyGameManager=null;
	// This static function can be used everywhere in your code to get the BLManager, once it has been instancianed : MyGameManager.getInstance()
	static public function getInstance():MyGameManager {
		return theOne;
	}
	
	function MyGameManager() {
		theOne=this;
	}
	
	// The BL API will call this when it wants you play this level data.
	// You must unserialize the data (interpret the data, draw the level, and laucnh the game)
	// official is 0 for a non official level, 1 for an official level not yet completed, 2 for an official level that the player has already completed once
	public function blPlayLvl(data:String,official:Number) {
		var res = _root.unserializeAndPlay(data);
		if (res === true) {
			sendPlayResult(true, "");
		} else {
			sendPlayResult(false, res);
		}
		
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		// During the game session, you have to call lvlCompleted(completed:Boolean,score:Number) when the play has completed the level.
		// Usually you call this with completed=true, when the player wants to go to the next level.
		// Even if the level is completed, you can propose to retry the level and try to improve the score, without calling lvlCompleted at the end of each try. Then you will only call lvlCompleted(completed:Boolean,score:Number) when the player deosn't want to retry anymore and with the best score achieved over the various tries.
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		
	}
	public function blWelcome() {
		_root.gotoAndStop(1);
	}
}
