﻿class MyUserData {
	// This is an example of basic user data.
	// This class is used by the game swf to serilalize/unserialize user data
	public var version:String;
	public var gold:Number;
	public var uitems:Number;

	public function MyUserData() {
		setDefault();
	}
	
	public function setDefault() {
		version="v1";
		setData(10,0);
	}
	
	public function setData(g:Number,i:Number) {
		gold=g;
		uitems=i;
	}
	
	// export level data
	public function serialize():String {
		var export:Serializer=new Serializer("");
		export.writeString(version);
		export.writeNumber(gold);
		export.writeNumber(uitems);
		return export.serialized;
	}
	
	// import level data
	public function unserialize(data:String) {
		if (data.length>0) { // If the user data is not empty (ie not the first time the player plays this game)
			var obj:Serializer=new Serializer(data);
			version=obj.readString();
			gold=obj.readNumber();
			uitems=obj.readNumber();
			if (obj.error>0) {
				setDefault();
			}
		} else setDefault(); //Very important to reinitialize the user data in that case. It can be a new player slot, and you must not keep the data of the former player
	}
}