﻿class MyUserDataGameManager extends MyGameManager {
	function MyUserDataGameManager() {
		
		requestUserData(); // We inform the API that we want to receive the user data. BL API will call blUserData in response, the first time and each time the player slot is modified.
			
		//////////////////////////////////////////////////////////////////////////////////////////////////////
		// During the game session, you have to call updateUserData(data:ByteArray) when you want to save the new player data.
		// For example, the user have just completed an official level for the first time, and he wins 1000 gold coins. Then you can serialize the new user data and call updateUserData(data:ByteArray).
		// He goes to the shop and buys a powerful weapon. Then you can serialize again the new user data and call updateUserData(data:ByteArray).
		//////////////////////////////////////////////////////////////////////////////////////////////////////
			
	}
	
	public function blNewUserData(res:Boolean,data:String) {
		_root.debug.text+="blNewUserData "+res+" "+data+"\n";
		// You may implement this function
		// Store the user data in memory, show a user CPanel etc...
		if (res) _root.unserializeAndShowUserData(data);
		else {
			// Show error...
			// TODO...
			_root.debug.text+=data+"\n";
		}

	}
	
	// This function is called by the BL API after you call updateUserData.
	// If res is true, the user data has been stored successfully
	// If res is false, there has been an error. In that case, data is the the error message.
	public function userDataUpdatedCbk(res:Boolean,data:String) {
		
		// You may implement this function
		// ...
		if (!res) {
			// Show error...
			// TODO...
			_root.debug.text+=data+"\n";
		}
	}
	
}
