﻿class Serializer {
	// This is a mini serializer/unserializer tool that needs to be improved with new methods (writeObject, writeArray etc...)
	// This class can be used to serialize level data or user data.
	// See MyUserData to see how to use it
	public var position:Number;
	public var serialized:String;
	public var error:Number;
	
	public function Serializer(s:String) {
		setData(s);
	}
	
	public function setData(s:String) {
		serialized=s;
		position=0;
		error=0;
	}
	
	public function readNumber() {
		var toreturn:Number=0;
		if (error==0) {
			var index:Number=serialized.indexOf("_",position);
			if (index>=0) {
				toreturn=Number(serialized.substring(position,index));
				position=index+1;
			} else {
				error=1;
			}
		}
		return toreturn;
	}
	
	public function readString() {
		var toreturn:String="";
		if (error==0) {
			var strlen:Number=readNumber();
			if (error==0) {
				toreturn=serialized.substring(position,position+strlen);
				position+=strlen;
			}
		}
		return toreturn;
	}
	
	public function writeNumber(n:Number) {
		serialized+=n+"_";
	}
	public function writeString(s:String) {
		serialized+=s.length+"_"+s;
	}
}